/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.htmlviewer;

import com.dandymadeproductions.htmlviewer.HTMLViewer;
import com.dandymadeproductions.lindyframe.utilities.LindyFrame_ResourceBundle;
import com.dandymadeproductions.lindyframe.utilities.LindyFrame_Utils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

class MenuActionListener
implements ActionListener {
    private JFrame parent;
    private HTMLViewer htmlViewer;
    private String resourceSearchFor;
    private String resourceStringNotFound;
    private String resourceFound;
    private String resourceMatches;
    private String resourceTitleAlert;
    private String resourceErrorFile;
    private String lastOpenDirectory;

    public MenuActionListener(JFrame jFrame, HTMLViewer hTMLViewer, LindyFrame_ResourceBundle lindyFrame_ResourceBundle) {
        this.parent = jFrame;
        this.htmlViewer = hTMLViewer;
        this.lastOpenDirectory = "";
        this.resourceSearchFor = lindyFrame_ResourceBundle.getResourceString("MenuActionListener.label.SearchFor", "Search For");
        this.resourceStringNotFound = lindyFrame_ResourceBundle.getResourceString("MenuActionListener.label.StringNotFound", "String Not Found");
        this.resourceFound = lindyFrame_ResourceBundle.getResourceString("MenuActionListener.label.Found", "Found");
        this.resourceMatches = lindyFrame_ResourceBundle.getResourceString("MenuActionListener.label.Matches", "Matches");
        this.resourceTitleAlert = lindyFrame_ResourceBundle.getResourceString("MenuActionListener.dialogtitle.Alert", "Alert");
        this.resourceErrorFile = lindyFrame_ResourceBundle.getResourceString("MenuActionListener.dialogmessage.FileNOTFound", "File NOT Found");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = object instanceof JMenuItem ? ((JMenuItem)object).getActionCommand() : (object instanceof JButton ? ((JButton)object).getActionCommand() : "");
        if (string.equals("File Open")) {
            this.openAction(this.parent);
            return;
        }
        if (string.equals("FE")) {
            return;
        }
        if (string.equals("Edit Search")) {
            this.searchAction(this.parent);
            return;
        }
    }

    private void openAction(JFrame jFrame) {
        JFileChooser jFileChooser = this.lastOpenDirectory.equals("") ? new JFileChooser() : new JFileChooser(new File(this.lastOpenDirectory));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = "";
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                return string.equals("html");
            }

            @Override
            public String getDescription() {
                return "HTML Files";
            }
        });
        int n = jFileChooser.showOpenDialog(jFrame);
        if (n == 0) {
            this.lastOpenDirectory = jFileChooser.getCurrentDirectory().toString();
            String string = jFileChooser.getSelectedFile().getName();
            string = jFileChooser.getCurrentDirectory() + LindyFrame_Utils.getFileSeparator() + string;
            if (!string.equals("")) {
                this.htmlViewer.loadPage("file:" + string);
            } else {
                JOptionPane.showMessageDialog(null, this.resourceErrorFile, this.resourceTitleAlert, 0);
            }
        }
    }

    private void searchAction(JFrame jFrame) {
        String string = JOptionPane.showInputDialog(jFrame, (Object)(this.resourceSearchFor + " :"));
        int n = this.htmlViewer.viewerPane.search(string);
        if (n > 0) {
            this.htmlViewer.setStatus(this.resourceFound + " " + n + " " + this.resourceMatches, -1, 3);
        } else {
            this.htmlViewer.setStatus(this.resourceStringNotFound, -1, 3);
        }
    }
}

