/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.htmlviewer;

import com.dandymadeproductions.htmlviewer.HTMLEditorPane;
import com.dandymadeproductions.htmlviewer.MenuActionListener;
import com.dandymadeproductions.htmlviewer.Viewer_MenuBar;
import com.dandymadeproductions.htmlviewer.Viewer_ToolBar;
import com.dandymadeproductions.lindyframe.LindyFrame;
import com.dandymadeproductions.lindyframe.gui.Main_Frame;
import com.dandymadeproductions.lindyframe.utilities.LindyFrame_ResourceBundle;
import com.dandymadeproductions.lindyframe.utilities.LindyFrame_Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

class HTMLViewer
implements ActionListener {
    private ImageIcon tabIcon;
    private GridBagLayout gridbag;
    private GridBagConstraints constraints;
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private JPanel urlEntryPanel;
    private JPanel statusPanel;
    private JButton historyBackButton;
    private JButton historyForwardButton;
    private JButton refreshButton;
    private JTextField urlEntryTextField;
    private LinkedList<String> historyList;
    protected HTMLEditorPane viewerPane;
    private JProgressBar progressBar;
    private JLabel statusLabel;
    private Viewer_MenuBar menuBar;
    private Viewer_ToolBar toolBar;
    private LindyFrame_ResourceBundle resourceBundle;
    private String loadingPageResource;
    private String pageNotFoundResource;
    private int stateHistoryIndex;
    private static final String VERSION = "Version 1.7";
    private static final String DESCRIPTION = "The HTMLViewer plugin provides a mean to demostrate a module example for the lindyFrame framework. The plugin is a basic HTML viewer that displays the tutorial for creating plugins with lindyFrame.";
    private static final int STATE_HISTORY_LIMIT = 25;

    public HTMLViewer(Main_Frame main_Frame, String string) {
        String string2 = string + "/HTMLViewer.jar";
        String string3 = "lib/plugins/HTMLViewer/locale/";
        String string4 = "lib/plugins/HTMLViewer/images/";
        this.resourceBundle = new LindyFrame_ResourceBundle(string2, LindyFrame.getDebug());
        this.resourceBundle.setLocaleResource(string3, "HTMLViewer", LindyFrame.getLocaleString());
        this.tabIcon = this.resourceBundle.getResourceImage(string4 + "icons/htmlViewerIcon.png");
        this.loadingPageResource = this.resourceBundle.getResourceString("HTMLViewer.label.LoadingPage", "Loading Page");
        this.pageNotFoundResource = this.resourceBundle.getResourceString("HTMLViewer.label.PageNotFound", "Page Not Found");
        this.gridbag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.initURLEntryPanel(string4);
        this.mainPanel.add((Component)this.urlEntryPanel, "North");
        this.initViewer();
        this.mainPanel.add((Component)new JScrollPane(this.viewerPane), "Center");
        this.initStatusPanel();
        this.mainPanel.add((Component)this.statusPanel, "South");
        MenuActionListener menuActionListener = new MenuActionListener((JFrame)main_Frame, this, this.resourceBundle);
        this.menuBar = new Viewer_MenuBar(main_Frame, this.resourceBundle, menuActionListener);
        this.toolBar = new Viewer_ToolBar("HTMLViewer ToolBar", main_Frame, string4, this.resourceBundle, menuActionListener);
        this.loadPage("file:" + LindyFrame_Utils.getResourceBundle().getResourceFile("docs/Plugins/Tutorial/LindyFrame_PluginTutorial.html").getPath());
    }

    private void initURLEntryPanel(String string) {
        this.urlEntryPanel = new JPanel(this.gridbag);
        this.urlEntryPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createEtchedBorder()));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        ImageIcon imageIcon = this.resourceBundle.getResourceImage(string + "icons/historyBackIcon.png");
        this.historyBackButton = new JButton(imageIcon);
        this.historyBackButton.setMargin(new Insets(0, 0, 0, 0));
        this.historyBackButton.setEnabled(false);
        this.historyBackButton.addActionListener(this);
        jPanel.add(this.historyBackButton);
        ImageIcon imageIcon2 = this.resourceBundle.getResourceImage(string + "icons/historyForwardIcon.png");
        this.historyForwardButton = new JButton(imageIcon2);
        this.historyForwardButton.setMargin(new Insets(0, 0, 0, 0));
        this.historyForwardButton.setEnabled(false);
        this.historyForwardButton.addActionListener(this);
        jPanel.add(this.historyForwardButton);
        LindyFrame_Utils.buildConstraints((GridBagConstraints)this.constraints, (int)0, (int)0, (int)1, (int)1, (double)2.0, (double)100.0);
        this.constraints.fill = 1;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jPanel, this.constraints);
        this.urlEntryPanel.add(jPanel);
        this.urlEntryTextField = new JTextField("");
        this.urlEntryTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2), BorderFactory.createLoweredBevelBorder()));
        this.urlEntryTextField.addMouseListener(LindyFrame.getPopupMenuListener());
        LindyFrame_Utils.buildConstraints((GridBagConstraints)this.constraints, (int)1, (int)0, (int)1, (int)1, (double)97.0, (double)100.0);
        this.constraints.fill = 1;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(this.urlEntryTextField, this.constraints);
        this.urlEntryPanel.add(this.urlEntryTextField);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        ImageIcon imageIcon3 = this.resourceBundle.getResourceImage(string + "icons/refreshIcon.png");
        this.refreshButton = new JButton(imageIcon3);
        this.refreshButton.setMargin(new Insets(0, 0, 0, 0));
        this.refreshButton.addActionListener(this);
        jPanel2.add(this.refreshButton);
        LindyFrame_Utils.buildConstraints((GridBagConstraints)this.constraints, (int)2, (int)0, (int)1, (int)1, (double)1.0, (double)100.0);
        this.constraints.fill = 1;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(jPanel2, this.constraints);
        this.urlEntryPanel.add(jPanel2);
        this.historyList = new LinkedList();
        this.stateHistoryIndex = -1;
        this.urlEntryTextField.addKeyListener(new KeyAdapter(){
            String lastURL = "";

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (HTMLViewer.this.urlEntryTextField.getText().trim().equals(this.lastURL)) {
                        return;
                    }
                    this.lastURL = HTMLViewer.this.urlEntryTextField.getText().trim();
                    HTMLViewer.this.historyList.add(this.lastURL);
                    HTMLViewer.this.historyBackButton.setEnabled(true);
                    HTMLViewer.this.stateHistoryIndex++;
                    HTMLViewer.this.updateViewer(HTMLViewer.this.urlEntryTextField.getText());
                }
            }
        });
    }

    private void initViewer() {
        this.viewerPane = new HTMLEditorPane();
        this.viewerPane.setMargin(new Insets(5, 5, 5, 5));
        this.viewerPane.setEditorKit(new HTMLEditorKit());
        this.viewerPane.setEditable(false);
        this.viewerPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HTMLViewer.this.updateViewer(hyperlinkEvent.getURL());
                }
            }
        });
        this.viewerPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("page")) {
                    HTMLViewer.this.setStatus(null);
                }
            }
        });
    }

    private void initStatusPanel() {
        this.statusPanel = new JPanel(this.gridbag);
        this.statusPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createLoweredBevelBorder()));
        this.progressBar = new JProgressBar();
        this.progressBar.setBorder(BorderFactory.createRaisedBevelBorder());
        LindyFrame_Utils.buildConstraints((GridBagConstraints)this.constraints, (int)0, (int)0, (int)1, (int)1, (double)10.0, (double)100.0);
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.gridbag.setConstraints(this.progressBar, this.constraints);
        this.statusPanel.add(this.progressBar);
        this.statusLabel = new JLabel();
        LindyFrame_Utils.buildConstraints((GridBagConstraints)this.constraints, (int)1, (int)0, (int)1, (int)1, (double)90.0, (double)100.0);
        this.constraints.fill = 2;
        this.constraints.anchor = 10;
        this.gridbag.setConstraints(this.statusLabel, this.constraints);
        this.statusPanel.add(this.statusLabel);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            if (object == this.historyBackButton || object == this.historyForwardButton) {
                this.executeHistoryAction(object);
            } else if (object == this.refreshButton) {
                this.setLocation(this.urlEntryTextField.getText().trim());
            }
        }
    }

    private void executeHistoryAction(Object object) {
        if (object == this.historyBackButton) {
            --this.stateHistoryIndex;
            if (this.stateHistoryIndex <= 0) {
                this.stateHistoryIndex = 0;
                this.historyBackButton.setEnabled(false);
            }
        }
        if (object == this.historyForwardButton) {
            ++this.stateHistoryIndex;
            if (this.stateHistoryIndex > 24) {
                this.stateHistoryIndex = 24;
                this.historyForwardButton.setEnabled(false);
            }
        }
        if (this.stateHistoryIndex == 0) {
            this.historyBackButton.setEnabled(false);
        } else {
            this.historyBackButton.setEnabled(true);
        }
        if (this.stateHistoryIndex < this.historyList.size() - 1) {
            this.historyForwardButton.setEnabled(true);
        } else {
            this.historyForwardButton.setEnabled(false);
        }
        if (object != null) {
            this.setLocation(this.historyList.get(this.stateHistoryIndex));
        }
    }

    private boolean setLocation(String string) {
        this.setStatus(" Loading Page " + string);
        this.progressBar.setIndeterminate(true);
        if (string.endsWith("/")) {
            string = string + "index.html";
        }
        final String string2 = string;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HTMLViewer.this.updateViewer(string2);
            }
        });
        return true;
    }

    public boolean updateViewer(String string) {
        try {
            return this.updateViewer(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Given url is not valid " + string);
            return false;
        }
    }

    public boolean updateViewer(URL uRL) {
        try {
            this.setStatus(this.loadingPageResource + ": " + uRL.toExternalForm());
            this.viewerPane.setPage(uRL);
        }
        catch (IOException iOException) {
            if (LindyFrame.getDebug()) {
                System.out.println("HTMLViewer.updateViewer() Could Not Load Page: " + uRL);
            }
            this.setStatus(this.pageNotFoundResource + ": " + uRL.toExternalForm());
            this.progressBar.setIndeterminate(false);
            this.progressBar.setVisible(false);
            return false;
        }
        return true;
    }

    private void setStatus(String string) {
        this.setStatus(string, string == null ? -1 : 101);
    }

    public void setStatus(String string, int n, final int n2) {
        this.setStatus(string, n);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(n2 * 1000);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                HTMLViewer.this.setStatus(null);
            }
        });
        thread.start();
    }

    private void setStatus(String string, int n) {
        this.statusLabel.setText(string == null ? " " : string);
        if (n < 0) {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setVisible(false);
        } else if (n > 100) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setVisible(true);
        } else {
            this.progressBar.setVisible(true);
            this.progressBar.setValue(n);
        }
    }

    protected void loadPage(String string) {
        if (this.setLocation(string)) {
            this.historyList.add(string);
            this.urlEntryTextField.setText(string);
            ++this.stateHistoryIndex;
            this.executeHistoryAction(null);
        }
    }

    protected JMenuBar getMenuBar() {
        return this.menuBar;
    }

    protected JToolBar getToolBar() {
        return this.toolBar;
    }

    protected JPanel getPanel() {
        return this.mainPanel;
    }

    protected String getVersion() {
        return VERSION;
    }

    protected String getDescription() {
        return DESCRIPTION;
    }

    protected ImageIcon getTabIcon() {
        return this.tabIcon;
    }
}

