/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.htmlviewer;

import com.dandymadeproductions.htmlviewer.WordSearcher;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;

public class HTMLEditorPane
extends JEditorPane {
    private static final long serialVersionUID = -1388878534761954412L;
    protected WordSearcher searcher = new WordSearcher(this);
    protected String lastSearch = null;
    protected Highlighter.Highlight[] h;
    protected int index = 0;

    @Override
    public void setPage(URL uRL) throws IOException {
        super.setPage(uRL);
        this.getHighlighter().removeAllHighlights();
    }

    public int search(String string) {
        int n = this.searcher.search(string);
        if (n != -1) {
            this.lastSearch = string;
            this.h = this.getHighlighter().getHighlights();
            this.index = 0;
            n = this.h[this.index].getStartOffset();
            try {
                this.scrollRectToVisible(this.modelToView(n));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return this.h.length;
        }
        return 0;
    }

    public void searchAgain() {
        if (this.lastSearch == null) {
            return;
        }
        if (this.h != null && this.h.length > 1) {
            this.index = this.index + 1 < this.h.length ? this.index + 1 : 0;
            int n = this.h[this.index].getStartOffset();
            try {
                this.scrollRectToVisible(this.modelToView(n));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

